/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.server.IPECommands;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWSystemWideInfo;
import java.util.Hashtable;

public final class VWSystemAdministration
implements IVWtoXML {
    public static final int SYSTEM_WIDE_UNDEFINED = 0;
    public static final int SYSTEM_WIDE_LOOP_DETECTION = 1;
    public static final int SYSTEM_WIDE_REMOVE_EXPIRED_TIMERS = 2;
    public static final int SYSTEM_WIDE_DELETE_PARENT = 4;
    public static final int SYSTEM_WIDE_DISABLE_STATISTICS = 16;
    public static final int SYSTEM_WIDE_DISABLE_TERMINATE = 32;
    public static final int SYSTEM_WIDE_DISABLE_NOTIFICATION = 64;
    public static final int SYSTEM_WIDE_FLAG_NO_ANALYSIS_ENG = 256;
    public static final int SYSTEM_WIDE_FLAG_CONSISTENT_RETURN = 512;
    public static final int SYSTEM_WIDE_FLAG_ENABLE_RULES = 1024;
    public static final int SYSTEM_WIDE_FLAG_ALLOW_ASYNC_RULES = 2048;
    private static final int SYSTEM_WIDE_ALL = 3959;
    protected int statisticsConsolidationInterval = 0;
    protected int systemWideFlags = 0;
    private static final int MIN_SYSTEM_WIDE_FLAG = 0;
    private static final int MAX_SYSTEM_WIDE_FLAG = 3959;
    protected VWSession serviceSession;
    protected IPECommands cmdSession;
    protected int sessionTimeOut = 20;
    protected Hashtable attributes = null;
    protected VWArrayHandler DBExecuteConnectionHandler = new VWArrayHandler();
    protected VWDBExecuteConnection[] theDBExecuteConnections = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:20:20 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/12 $";
    }

    protected VWSystemAdministration(VWSession theServiceSession) throws VWException {
        this.serviceSession = theServiceSession;
        this.cmdSession = this.serviceSession.getCmdSession();
        this.fetchSystemWideConfig();
    }

    protected VWUserInfo createUserInfo(String theUserName) throws VWException {
        VWUserInfo theUserInfo = this.serviceSession.fetchUserInfo(theUserName);
        return theUserInfo;
    }

    public VWUserInfo createUserInfo() throws VWException {
        throw new VWException("vw.api.VWSystemAdministionMethodDeprecated", "This method has been deprecated, only the server can create VWUserInfo records see VWSession.fetchUserInfo for edit.");
    }

    protected VWUserInfo createUserInfoByDomain(String theDomainName, String theUserName) throws VWException {
        VWUserInfo theUserInfo = this.serviceSession.fetchUserInfo(theUserName);
        return theUserInfo;
    }

    public void deleteUserInfo(String theUserName) throws VWException {
        if (theUserName == null || theUserName.length() < 1) {
            throw new VWException("vw.api.SAdeleteUserInfoNameNull", "deleteUserName parameter name is null.");
        }
        this.serviceSession.checkSession();
        this.cmdSession.deleteUserInfo(theUserName);
    }

    public VWUserInfo fetchUserInfo(String theUserName) throws VWException {
        if (theUserName == null || theUserName.length() < 1) {
            throw new VWException("vw.api.SAfetchUserInfoNameNull", "fetchUserName parameter name is null.");
        }
        this.serviceSession.checkSession();
        String[] theUserNameList = new String[]{theUserName};
        VWEnvironmentData[] theUserData = this.cmdSession.fetchUserInfo(theUserNameList);
        if (theUserData != null && theUserData.length > 0 && theUserData[0].getUserName() != null) {
            return new VWUserInfo(this.serviceSession, theUserData[0]);
        }
        throw new VWException("vw.api.VWSystemAdminNoUser", "The user {0} does not exist.", theUserName.toString());
    }

    private void fetchSystemWideConfig() throws VWException {
        VWSystemWideInfo sysInfo = this.cmdSession.getSystemWideConfig();
        if (sysInfo != null) {
            this.statisticsConsolidationInterval = sysInfo.getStatisticsConsolidationInterval();
            this.systemWideFlags = sysInfo.getSystemWideFlags();
            this.sessionTimeOut = sysInfo.getSessionTimeOut();
            this.attributes = sysInfo.getAttributes();
            VWDBExecuteConnection[] thelocalDBExecuteConnections = sysInfo.getDBExecuteConnections();
            if (thelocalDBExecuteConnections != null) {
                for (int i = 0; i < thelocalDBExecuteConnections.length; ++i) {
                    this.theDBExecuteConnections = (VWDBExecuteConnection[])this.DBExecuteConnectionHandler.addElementToArray(this.theDBExecuteConnections, thelocalDBExecuteConnections[i]);
                }
            }
        }
    }

    public int getStatisticsConsolidationInterval() throws VWException {
        if (this.statisticsConsolidationInterval == 0) {
            this.fetchSystemWideConfig();
        }
        return this.statisticsConsolidationInterval;
    }

    public void setStatisticsConsolidationInterval(int theInterval) throws VWException {
        this.serviceSession.checkSession();
        if (this.systemWideFlags == 0) {
            this.fetchSystemWideConfig();
        }
        this.statisticsConsolidationInterval = theInterval;
        this.commit();
    }

    public void setSystemWideFlags(int theFlags) throws VWException {
        this.serviceSession.checkSession();
        if (theFlags < 0 || theFlags > 3959) {
            throw new VWException("vw.api.VWSystemAdminInvalidSystemWideFlag", "Invalid system wide flag {0}.", new Integer(theFlags));
        }
        if (this.statisticsConsolidationInterval == 0) {
            this.fetchSystemWideConfig();
        }
        this.systemWideFlags = theFlags;
        this.commit();
    }

    public void setSystemFlags(int theFlags) throws VWException {
        this.serviceSession.checkSession();
        if (theFlags < 0 || theFlags > 3959) {
            throw new VWException("vw.api.VWSystemAdminInvalidSystemWideFlag", "Invalid system wide flag {0}.", new Integer(theFlags));
        }
        if (this.statisticsConsolidationInterval == 0) {
            this.fetchSystemWideConfig();
        }
        this.systemWideFlags = theFlags;
    }

    public int getSystemWideFlags() throws VWException {
        return this.systemWideFlags;
    }

    public int getSessionTimeOut() throws VWException {
        if (this.sessionTimeOut == 0) {
            this.fetchSystemWideConfig();
        }
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int theSessionTimeOut) throws VWException {
        this.serviceSession.checkSession();
        if (theSessionTimeOut < 1) {
            throw new VWException("vw.api.VWSystemAdministrationBadTimeOutValue", "The session timeout needs to be greater than 0 seconds. {0}", new Integer(theSessionTimeOut));
        }
        if (this.systemWideFlags == 0) {
            this.fetchSystemWideConfig();
        }
        this.sessionTimeOut = theSessionTimeOut;
    }

    public void commit() throws VWException {
        VWSystemWideInfo sysInfo = new VWSystemWideInfo();
        sysInfo.setStatisticsConsolidationInterval(this.statisticsConsolidationInterval);
        sysInfo.setSystemWideFlags(this.systemWideFlags);
        sysInfo.setSessionTimeOut(this.sessionTimeOut);
        sysInfo.setAttributes(this.attributes);
        sysInfo.setDBExecuteConnections(this.theDBExecuteConnections);
        this.cmdSession.setSystemWideConfig(sysInfo);
    }

    public int getStatisticsSnapshotInterval() throws VWException {
        return 0;
    }

    public void setStatisticsSnapshotInterval(int theInterval) throws VWException {
    }

    public void initializeRegion() throws VWException {
        this.serviceSession.checkSession();
        this.cmdSession.initializeRegion(false, this.serviceSession.getDefaultWebApplication());
    }

    public void removeRegion() throws VWException {
        this.serviceSession.checkSession();
        this.cmdSession.initializeRegion(true, this.serviceSession.getDefaultWebApplication());
    }

    public void removeAllRegions() throws VWException {
        this.serviceSession.checkSession();
        this.cmdSession.initializeAllRegions();
    }

    public void removeWorkflowDatabase() throws VWException {
        this.serviceSession.checkSession();
        this.cmdSession.removeDatabase();
    }

    public void removeLinkFlag(String theDocument) throws VWException {
        this.serviceSession.checkSession();
        this.cmdSession.removeLinkFlag(theDocument);
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        this.serviceSession.checkSession();
        if (this.attributes == null) {
            this.fetchSystemWideConfig();
        }
        return new VWAttributeInfo(this.attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
    }

    protected Hashtable getAttributes() throws VWException {
        this.serviceSession.checkSession();
        if (this.systemWideFlags == 0) {
            this.fetchSystemWideConfig();
        }
        return this.attributes;
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.attributes = theAttributes;
    }

    protected String[] getAttributeNames() throws VWException {
        this.serviceSession.checkSession();
        if (this.systemWideFlags == 0) {
            this.attributes = this.getAttributes();
        }
        return VWAttributeInfo.getAttributeNames(this.attributes);
    }

    public VWDBExecuteConnection[] getDBExecutionConnections() throws VWException {
        if (this.theDBExecuteConnections == null) {
            this.fetchSystemWideConfig();
        }
        return (VWDBExecuteConnection[])this.DBExecuteConnectionHandler.getElements(this.theDBExecuteConnections);
    }

    public VWDBExecuteConnection[] fetchDBExecutionConnections() throws VWException {
        this.theDBExecuteConnections = null;
        this.fetchSystemWideConfig();
        return (VWDBExecuteConnection[])this.DBExecuteConnectionHandler.getElements(this.theDBExecuteConnections);
    }

    public VWDBExecuteConnection getDBExecutionConnection(String name) throws VWException {
        VWDBExecuteConnection[] dbExeLit = this.getDBExecutionConnections();
        if (dbExeLit != null) {
            for (int i = 0; i < dbExeLit.length; ++i) {
                if (!dbExeLit[i].getName().equals(name)) continue;
                return dbExeLit[i];
            }
        }
        return null;
    }

    public VWDBExecuteConnection createDBExecutionConnection(String theName) throws VWException {
        Object[] theElements;
        int theIndex;
        if (this.theDBExecuteConnections == null) {
            this.fetchSystemWideConfig();
        }
        if ((theIndex = this.DBExecuteConnectionHandler.getIndexFromStringFieldValue(theElements = (VWDBExecuteConnection[])this.DBExecuteConnectionHandler.getElements(this.theDBExecuteConnections), "m_name", theName)) != -1) {
            throw new VWException("vw.api.VWSystemAdministrationDBExecuteConnectioneExists", "The DBExecute already exists.");
        }
        VWDBExecuteConnection theDBExecute = new VWDBExecuteConnection();
        theDBExecute.setName(theName);
        theDBExecute.setHasChanged(true);
        this.theDBExecuteConnections = (VWDBExecuteConnection[])this.DBExecuteConnectionHandler.addElementToArray(this.theDBExecuteConnections, theDBExecute);
        return theDBExecute;
    }

    public void deleteDBExecutionConnection(VWDBExecuteConnection theDBEx) throws VWException {
        if (this.theDBExecuteConnections == null) {
            this.fetchSystemWideConfig();
        }
        int idx = -1;
        for (int i = 0; i < this.DBExecuteConnectionHandler.getElementCount(); ++i) {
            if (!this.theDBExecuteConnections[i].equals(theDBEx)) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            throw new VWException("vw.api.VWSystemAdministrationInvalidDBExecute", "Invalid DBExecution connection. Deletion failed.");
        }
        this.DBExecuteConnectionHandler.deleteElementFromArray(this.theDBExecuteConnections, idx);
    }

    public boolean verifyDBConnection(VWDBExecuteConnection dbConnection) throws VWException {
        return this.cmdSession.verifyDBConnection(dbConnection);
    }

    public String toString() {
        return String.valueOf(this.serviceSession.isolatedRegion);
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWSystemAdministrationNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        theBuffer.append(INDENT_0 + "<" + "SystemAdministration" + "\n");
        theBuffer.append(INDENT_1 + "SessionTimeOut" + "=\"" + this.getSessionTimeOut() + "\"\n");
        theBuffer.append(INDENT_1 + "StatisticsConsolidationInterval" + "=\"" + this.getStatisticsConsolidationInterval() + "\"\n");
        theBuffer.append(INDENT_1 + "SystemWideFlags" + "=\"" + this.getSystemWideFlags() + "\"");
        theBuffer.append(">\n");
        VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
        theAttributeInfo.toXML(theBuffer, INDENT_1);
        theBuffer.append(INDENT_1 + "<" + "ArrayOfDBExecuteConnection" + ">\n");
        VWDBExecuteConnection[] dbExeList = this.getDBExecutionConnections();
        if (dbExeList != null && dbExeList.length > 0) {
            for (int i = 0; i < dbExeList.length; ++i) {
                dbExeList[i].toXML(theBuffer, INDENT_2, false);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfDBExecuteConnection" + ">\n");
        theBuffer.append(INDENT_0 + "</" + "SystemAdministration" + ">\n");
    }
}

